# Conflict type / Enemy type
# "type" (from UCDP Codebook): We define four types of conflict:
#   [ 1. Extrasystemic armed conflict occurs between a state and a non-state group outside its own territory. (In the COW project, extrasystemic war is subdivided into colonial war and imperial war, but this distinction is not used here.) These conflicts are by definition territorial, since the government side is fighting to retain control of a territory outside the state system. ]
#       (Non-existend in the data!)
#   2. Interstate armed conflict occurs between two or more states.
#   3. Internal armed conflict occurs between the government of a state and one or more internal
#       opposition group(s) without intervention from other states.
#   4. Internationalized internal armed conflict occurs between the government of a state and one or
#       more internal opposition group(s) with intervention from other states (secondary parties) on one or both sides.

# enemy is state actor
Master$type_interstate <- 0 
Master$type_interstate[Master$type == 2] <- 1

# enemy is non-state actor
Master$type_intrastate <- 0
Master$type_intrastate[Master$type == 3] <- 1

# enemies are non-state and state actors
Master$type_internationalized <- 0
Master$type_internationalized[Master$type == 4] <- 1
